function maxSpd = vehMaxSpd(veh)
% Check speed
mis.time = 0;
mis.vehDist = 0;
mis.vehSpd = 0;
mis.vehAcc = 0;
mis.vehGrad = 0;
mis.eRoad = 0;

gnSet = (1:length(veh.gb.gear))';
switch veh.vehType
    case 'conv'
        vehModel = @(mis) convModel({gnSet}, {gnSet, 0}, mis, veh);
    case 'bev'
        vehModel = @(mis) bevModel({1}, {gnSet, 0}, mis, veh);
end

maxSpd = 220; % km/h

spdVec = 0:(1/3.6):maxSpd;
for n = 1:length(spdVec)
    mis.vehSpd = spdVec(n);
    [~, unfeas] = vehModel(mis);
    if all(unfeas)
        break
    end
    maxSpd = spdVec(n);
end


end